/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.dev.designgridlayout.ComponentGapsHelper;
import net.java.dev.designgridlayout.ComponentHelper;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.ISubGrid;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.MarkerHelper;
import net.java.dev.designgridlayout.RowItem;

final class SubGrid
implements ISubGrid {
    private static final String NO_PREVIOUS_SUBGRID = "spanRow() cannot work on a grid-row with no grid-row immediately above, or with no matching sub-grid (same column position) in the above grid-row";
    private static final String NO_MATCHING_COMPONENT = "spanRow() cannot work when there is no component, on the above grid-row, with a matching column location";
    private static final String UNMATCHED_COLUMNS_SUBGRIDS = "spanRow() cannot work on a sub-grid where the number of columns is different from the above sub-grid";
    private static final JComponent EMPTY = new JPanel();
    private final List<RowItem> _items;
    private final SubGrid _previous;
    private final Container _parent;
    private final JLabel _label;
    private int _gridspan;
    private boolean _spanRow;
    private int _column = 0;
    private int _indent = 0;

    SubGrid(List<RowItem> items, SubGrid previous, Container parent, JLabel label, int gridspan) {
        this._items = items;
        this._previous = previous;
        this._parent = parent;
        this._label = label;
        int n = this._gridspan = gridspan <= 0 ? 0 : gridspan;
        if (this._label != null) {
            this._parent.add(this._label);
        }
    }

    void spanRow() {
        if (this._previous == null) {
            this.add(MarkerHelper.createMarker(1, NO_PREVIOUS_SUBGRID), 1);
        } else {
            RowItem previous = this._previous.findItem(this._column);
            if (previous == null) {
                this.add(MarkerHelper.createMarker(1, NO_MATCHING_COMPONENT), 1);
            } else {
                this._spanRow = true;
                this._items.add(new RowItem(previous));
            }
        }
    }

    void indent(int n) {
        this._indent = ComponentGapsHelper.instance().getHorizontalIndent() * n;
    }

    void add(JComponent child, int span2) {
        RowItem item;
        if (child != null) {
            item = new RowItem(span2, child);
            this._parent.add(child);
        } else {
            item = new RowItem(span2, EMPTY);
        }
        this._column += span2;
        this._items.add(item);
    }

    void checkSpanRows() {
        if (!this._spanRow) {
            return;
        }
        if (this._previous.gridColumns() != this.gridColumns()) {
            for (RowItem item : this._items) {
                if (item.isFirstSpanRow()) continue;
                JComponent marker = MarkerHelper.createMarker(item.span(), UNMATCHED_COLUMNS_SUBGRIDS);
                item.replace(marker);
                this._parent.add(marker);
            }
        }
    }

    JLabel label() {
        return this._label;
    }

    JComponent leftComponent() {
        if (this._label != null) {
            return this._label;
        }
        return this._items.isEmpty() ? null : this._items.get(0).component();
    }

    @Override
    public int gridspan() {
        return this._gridspan;
    }

    public void gridspan(int span2) {
        if (this._previous != null && this._spanRow) {
            this._gridspan = this._previous.gridspan();
        }
        if (this._gridspan == 0) {
            this._gridspan = span2;
        }
    }

    @Override
    public int labelWidth() {
        return (this._label != null ? this._label.getPreferredSize().width : 0) + this._indent;
    }

    @Override
    public int gridColumns() {
        int columns = 0;
        for (RowItem item : this._items) {
            columns += item.span();
        }
        return columns;
    }

    @Override
    public int maxColumnWidth(int maxColumns, IExtractor extractor) {
        int maxWidth2 = 0;
        int columns = this.gridColumns();
        float divisions = (float)columns / (float)maxColumns;
        for (RowItem item : this._items) {
            int width = extractor.value(item);
            width = (int)((float)width * divisions / (float)item.span());
            maxWidth2 = Math.max(maxWidth2, width);
        }
        return maxWidth2;
    }

    public int hgap() {
        return ComponentHelper.hgap(this._label, this._items, this._parent);
    }

    public int layoutRow(LayoutHelper helper, int left, int height, int baseline, int hgap, int rowWidth, int labelWidth) {
        int columns;
        int x = left;
        int actualHeight = 0;
        if (labelWidth > 0) {
            if (this._label != null) {
                actualHeight = Math.max(0, helper.setSizeLocation(this._label, x + this._indent, labelWidth - this._indent, height, baseline));
            }
            x += labelWidth + hgap;
        }
        if ((columns = this.gridColumns()) > 0) {
            int gridWidth = rowWidth - (columns - 1) * hgap;
            int columnWidth = gridWidth / columns;
            int fudge = gridWidth % columns;
            Iterator<RowItem> i = this._items.iterator();
            while (i.hasNext()) {
                RowItem item = i.next();
                int span2 = item.span();
                int width = columnWidth * span2 + (span2 - 1) * hgap;
                if (!i.hasNext()) {
                    width += fudge;
                }
                if (item.isFirstSpanRow()) {
                    JComponent component = item.component();
                    actualHeight = Math.max(0, helper.setSizeLocation(component, x, width, height, baseline));
                }
                x += width + hgap;
            }
        }
        return actualHeight;
    }

    public List<RowItem> items() {
        return this._items;
    }

    private RowItem findItem(int column) {
        int i = 0;
        for (RowItem item : this._items) {
            if (i == column) {
                return item;
            }
            if ((i += item.span()) <= column) continue;
            return null;
        }
        return null;
    }

    static {
        EMPTY.setOpaque(false);
    }
}

